import java.io.*;
import java.nio.file.*;

class TryWithResources {
	static double mean(Path file) throws IOException {
		double sum = 0.0;
		int n = 0;
		try (var dis = new DataInputStream(Files.newInputStream(file))) {
			while (dis.available() > 0) {
				n++;
				sum += dis.readDouble();
			}
		}
		return sum / n;
	}

	public static void main(String args[]) throws IOException {
		Path file = Path.of("werte.dat");
		System.out.println(mean(file));
	}
}
